USE [{DBName}]

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Log]') AND name = N'IX_qi_Log_LogType_ProcessStatus_SyncLastCallDate_Date_InternalID')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_Log_LogType_ProcessStatus_SyncLastCallDate_Date_InternalID] ON [dbo].[qi_Log]
	(
		[LogType] ASC,
		[ProcessStatus] ASC,
		[SyncLastCallDate] ASC,
		[Date] ASC,
		[InternalID] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_GoodsGroupRelations]') AND name = N'IX_qi_GoodsGroupRelations_GoodsICU_GoodsGroupICU')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_GoodsGroupRelations_GoodsICU_GoodsGroupICU] ON [dbo].[qi_GoodsGroupRelations]
	(
		[GoodsIC] ASC,
		[GoodsU] ASC,
		[GoodsGroupIC] ASC,
		[GoodsGroupU] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Goods]') AND name = N'IX_qi_Goods_RepresentativeICU_DisplayInLists_IC_U_Code')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_Goods_RepresentativeICU_DisplayInLists_IC_U_Code] ON [dbo].[qi_Goods]
	(
		[RepresentativeIC] ASC,
		[RepresentativeU] ASC,
		[DisplayInLists] ASC,
		[IC] ASC,
		[U] ASC,
		[Code] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END


IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Orders]') AND name = N'IX_qi_Orders_RegistrationDate_ProcessStatus_PaymentStatus_SyncRetryCount')
BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_Orders_RegistrationDate_ProcessStatus_PaymentStatus_SyncRetryCount] ON [dbo].[qi_Orders]
	(
		[RegistrationDate] ASC,
		[ProcessStatus] ASC,
		[PaymentStatus] ASC,
		[SyncRetryCount] ASC
	)
	INCLUDE([InternalID],[SyncLastCallDate],[PaymentNumber]) 
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END



BEGIN TRY
  EXEC sp_updatestats
END TRY
BEGIN CATCH
  -- ignore, probably permissions missing
END CATCH

GO
COMMIT